/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemClock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ICompatibilty;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.IFaction;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumAvailabilityDialog;
import noppes.npcs.constants.EnumAvailabilityFaction;
import noppes.npcs.constants.EnumAvailabilityFactionType;
import noppes.npcs.constants.EnumAvailabilityPlayerName;
import noppes.npcs.constants.EnumAvailabilityQuest;
import noppes.npcs.constants.EnumAvailabilityRegion;
import noppes.npcs.constants.EnumAvailabilityScoreboard;
import noppes.npcs.constants.EnumAvailabilityStackData;
import noppes.npcs.constants.EnumAvailabilityStoredData;
import noppes.npcs.constants.EnumDayTime;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.AvailabilityFactionData;
import noppes.npcs.controllers.data.AvailabilityScoreboardData;
import noppes.npcs.controllers.data.AvailabilityStackData;
import noppes.npcs.controllers.data.AvailabilityStoredData;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.Zone3D;
import noppes.npcs.reflection.scoreboard.ScoreboardReflection;
import noppes.npcs.util.ValueUtil;

public class Availability
implements ICompatibilty,
IAvailability {
    public static HashSet<String> scores = new HashSet();
    public int[] daytime = new int[]{0, 0};
    public final Map<Integer, EnumAvailabilityDialog> dialogues = new TreeMap<Integer, EnumAvailabilityDialog>();
    public final Map<Integer, AvailabilityFactionData> factions = new TreeMap<Integer, AvailabilityFactionData>();
    private boolean hasOptions = false;
    public int max = 10;
    public int minPlayerLevel = 0;
    public int health = 100;
    public int healthType = 0;
    public final Map<Integer, EnumAvailabilityQuest> quests = new TreeMap<Integer, EnumAvailabilityQuest>();
    public final Map<String, AvailabilityScoreboardData> scoreboards = new TreeMap<String, AvailabilityScoreboardData>();
    public final Map<String, EnumAvailabilityPlayerName> playerNames = new TreeMap<String, EnumAvailabilityPlayerName>();
    public final Map<Integer, EnumAvailabilityRegion> regions = new TreeMap<Integer, EnumAvailabilityRegion>();
    public final Map<Integer, AvailabilityStackData> stacksData = new TreeMap<Integer, AvailabilityStackData>();
    public final NpcMiscInventory stacks = new NpcMiscInventory(9);
    public final List<AvailabilityStoredData> storeddata = new ArrayList<AvailabilityStoredData>();
    public boolean onlyGM = false;
    public int version = VersionCompatibility.ModRev;

    public Availability() {
        for (int i = 0; i < 9; ++i) {
            this.stacksData.put(i, new AvailabilityStackData());
        }
    }

    private boolean checkHasOptions() {
        for (EnumAvailabilityDialog ead : this.dialogues.values()) {
            if (ead == EnumAvailabilityDialog.Always) continue;
            return true;
        }
        for (EnumAvailabilityQuest eaq : this.quests.values()) {
            if (eaq == EnumAvailabilityQuest.Always) continue;
            return true;
        }
        for (AvailabilityFactionData afd : this.factions.values()) {
            if (afd.factionAvailable == EnumAvailabilityFactionType.Always) continue;
            return true;
        }
        for (String obj : this.scoreboards.keySet()) {
            if (obj.isEmpty()) continue;
            return true;
        }
        if (!this.playerNames.isEmpty()) {
            return true;
        }
        if (!this.storeddata.isEmpty()) {
            return true;
        }
        if (this.hasHealth()) {
            return true;
        }
        if (this.daytime[0] >= 0 && this.daytime[0] <= 23 && this.daytime[1] >= 0 && this.daytime[1] <= 23 && this.daytime[0] != this.daytime[1]) {
            return true;
        }
        for (ItemStack stack : this.stacks.items) {
            if (NoppesUtilServer.IsItemStackNull(stack)) continue;
            return true;
        }
        if (!this.regions.isEmpty()) {
            BorderController bData = BorderController.getInstance();
            for (int id : this.regions.keySet()) {
                if (this.regions.get(id) == EnumAvailabilityRegion.Always || !bData.regions.containsKey(id)) continue;
                return true;
            }
        }
        return this.minPlayerLevel > 0 || this.onlyGM;
    }

    public void clear() {
        this.hasOptions = false;
        this.daytime[0] = 0;
        this.daytime[1] = 0;
        this.minPlayerLevel = 0;
        this.health = 100;
        this.healthType = 0;
        this.dialogues.clear();
        this.quests.clear();
        this.factions.clear();
        this.scoreboards.clear();
        this.playerNames.clear();
    }

    public boolean dialogAvailable(int id, EnumAvailabilityDialog en, EntityPlayer player) {
        if (en == EnumAvailabilityDialog.Always) {
            return true;
        }
        boolean hasRead = PlayerData.get((EntityPlayer)player).dialogData.has(id);
        return hasRead && en == EnumAvailabilityDialog.After || !hasRead && en == EnumAvailabilityDialog.Before;
    }

    public boolean factionAvailable(int id, EnumAvailabilityFaction stance, EnumAvailabilityFactionType available, EntityPlayer player) {
        if (available == EnumAvailabilityFactionType.Always) {
            return true;
        }
        Faction faction = FactionController.instance.getFaction(id);
        if (faction == null) {
            return true;
        }
        PlayerFactionData data = PlayerData.get((EntityPlayer)player).factionData;
        int points = data.getFactionPoints(player, id);
        EnumAvailabilityFaction current = EnumAvailabilityFaction.Neutral;
        if (points < faction.neutralPoints) {
            current = EnumAvailabilityFaction.Hostile;
        }
        if (points >= faction.friendlyPoints) {
            current = EnumAvailabilityFaction.Friendly;
        }
        return available == EnumAvailabilityFactionType.Is && stance == current || available == EnumAvailabilityFactionType.IsNot && stance != current;
    }

    @Override
    public int[] getDaytime() {
        return this.daytime;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getHealthType() {
        return this.healthType;
    }

    @Override
    public int getMinPlayerLevel() {
        return this.minPlayerLevel;
    }

    @Override
    public String[] getPlayerNames() {
        return this.playerNames.keySet().toArray(new String[0]);
    }

    @Override
    public String getStoredDataValue(String key) {
        for (AvailabilityStoredData sd : this.storeddata) {
            if (!sd.key.equals(key)) continue;
            return sd.value;
        }
        return null;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean hasDialog(int id) {
        return this.dialogues.containsKey(id);
    }

    @Override
    public boolean hasFaction(int id) {
        return this.factions.containsKey(id);
    }

    public boolean hasHealth() {
        return this.healthType != 0;
    }

    public boolean hasOptions() {
        return this.hasOptions;
    }

    @Override
    public boolean hasPlayerName(String name) {
        return this.playerNames.containsKey(name);
    }

    @Override
    public boolean hasQuest(int id) {
        return this.quests.containsKey(id);
    }

    @Override
    public boolean hasScoreboard(String objective) {
        if (this.scoreboards.containsKey(objective)) {
            return true;
        }
        for (String obj : this.scoreboards.keySet()) {
            if (!obj.equals(objective)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStoredData(String key, String value) {
        for (AvailabilityStoredData sd : this.storeddata) {
            if (!sd.key.equals(key) || !sd.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    private void initScore(String objective) {
        if (objective == null || objective.isEmpty()) {
            return;
        }
        scores.add(objective);
        if (CustomNpcs.Server == null) {
            return;
        }
        for (WorldServer world : CustomNpcs.Server.field_71305_c) {
            Set<ScoreObjective> addedObjectives;
            ServerScoreboard board = (ServerScoreboard)world.func_96441_U();
            ScoreObjective so = board.func_96518_b(objective);
            if (so == null || (addedObjectives = ScoreboardReflection.getAddedObjectives(board)) == null || addedObjectives.contains(so)) continue;
            board.func_96549_e(so);
        }
    }

    public boolean isAvailable(EntityPlayer player) {
        int id;
        if (!this.hasOptions) {
            return true;
        }
        if (this.daytime[0] >= 0 && this.daytime[0] <= 23 && this.daytime[1] >= 0 && this.daytime[1] <= 23 && this.daytime[0] != this.daytime[1]) {
            int time = (int)((player.field_70170_p.func_72820_D() + 30000L) % 24000L) / 1000;
            if (this.daytime[0] < this.daytime[1]) {
                return time > this.daytime[0] && time < this.daytime[1];
            }
            return time > this.daytime[0] || time < this.daytime[1];
        }
        Iterator<Object> time = this.dialogues.keySet().iterator();
        while (time.hasNext()) {
            id = time.next();
            if (this.dialogAvailable(id, this.dialogues.get(id), player)) continue;
            return false;
        }
        time = this.quests.keySet().iterator();
        while (time.hasNext()) {
            id = time.next();
            if (this.questAvailable(id, this.quests.get(id), player)) continue;
            return false;
        }
        time = this.factions.keySet().iterator();
        while (time.hasNext()) {
            id = time.next();
            if (this.factionAvailable(id, this.factions.get((Object)Integer.valueOf((int)id)).factionStance, this.factions.get((Object)Integer.valueOf((int)id)).factionAvailable, player)) continue;
            return false;
        }
        for (String obj : this.scoreboards.keySet()) {
            if (this.scoreboardAvailable(player, obj, this.scoreboards.get((Object)obj).scoreboardType, this.scoreboards.get((Object)obj).scoreboardValue)) continue;
            return false;
        }
        boolean returnName = false;
        boolean hasOnly = false;
        for (String string : this.playerNames.keySet()) {
            boolean exit = false;
            switch (this.playerNames.get(string)) {
                case Only: {
                    hasOnly = true;
                    if (!player.func_70005_c_().equals(string)) break;
                    hasOnly = false;
                    exit = true;
                    break;
                }
                case Except: {
                    if (!player.func_70005_c_().equals(string)) break;
                    returnName = true;
                    exit = true;
                }
            }
            if (!exit) continue;
            break;
        }
        if (returnName || hasOnly) {
            return false;
        }
        if (!this.storeddata.isEmpty()) {
            IData dataP = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player).getStoreddata();
            for (AvailabilityStoredData sd : this.storeddata) {
                EnumAvailabilityStoredData type = sd.type;
                Object value = dataP.get(sd.key);
                boolean isNumber = false;
                if (type != EnumAvailabilityStoredData.ONLY && type != EnumAvailabilityStoredData.EXCEPT) {
                    if (!(value instanceof Number) && !(value instanceof String)) {
                        return false;
                    }
                    try {
                        double dsV;
                        double aV = Double.parseDouble(sd.value);
                        double d = dsV = value instanceof Number ? (Double)value : Double.parseDouble((String)value);
                        if (type == EnumAvailabilityStoredData.EQUAL && dsV != aV) {
                            return false;
                        }
                        if (type == EnumAvailabilityStoredData.BIGGER && dsV < aV) {
                            return false;
                        }
                        if (type == EnumAvailabilityStoredData.SMALLER && dsV > aV) {
                            return false;
                        }
                        isNumber = true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (isNumber || (!dataP.has(sd.key) || type != EnumAvailabilityStoredData.EXCEPT) && (dataP.has(sd.key) || type != EnumAvailabilityStoredData.ONLY)) continue;
                return false;
            }
        }
        if (this.healthType != 0) {
            int h = (int)(player.func_110143_aJ() / player.func_110138_aP() * 100.0f);
            if (this.healthType == 1 && h < this.health || this.healthType == 2 && h > this.health) {
                return false;
            }
        }
        if (this.onlyGM && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        for (int n : this.stacksData.keySet()) {
            AvailabilityStackData aData = this.stacksData.get(n);
            if (aData.type == EnumAvailabilityStackData.Always) continue;
            ItemStack aStack = this.stacks.func_70301_a(n);
            boolean found = false;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (NoppesUtilServer.IsItemStackNull(stack) || !NoppesUtilPlayer.compareItems(stack, aStack, aData.ignoreDamage, aData.ignoreNBT)) continue;
                found = true;
                break;
            }
            if ((!found || aData.type != EnumAvailabilityStackData.Except) && (found || aData.type != EnumAvailabilityStackData.Contains)) continue;
            return false;
        }
        if (!this.regions.isEmpty()) {
            BorderController bData = BorderController.getInstance();
            for (int id2 : this.regions.keySet()) {
                boolean inSide;
                EnumAvailabilityRegion aData = this.regions.get(id2);
                if (aData == EnumAvailabilityRegion.Always) continue;
                Zone3D region = bData.regions.get(id2);
                boolean bl = inSide = player.field_70170_p.field_73011_w.getDimension() == region.dimensionID && region.contains(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70131_O);
                if ((!inSide || aData != EnumAvailabilityRegion.OutSide) && (inSide || aData != EnumAvailabilityRegion.InSide)) continue;
                return false;
            }
        }
        return player.field_71068_ca >= this.minPlayerLevel;
    }

    @Override
    public boolean isAvailable(IPlayer<?> player) {
        return this.isAvailable((EntityPlayer)player.getMCEntity());
    }

    public boolean questAvailable(int id, EnumAvailabilityQuest en, EntityPlayer player) {
        switch (en) {
            case Always: {
                return true;
            }
            case After: {
                return PlayerQuestController.isQuestFinished(player, id);
            }
            case Before: {
                return !PlayerQuestController.isQuestFinished(player, id);
            }
            case Active: {
                return PlayerQuestController.isQuestActive(player, id);
            }
            case NotActive: {
                return !PlayerQuestController.isQuestActive(player, id);
            }
            case Completed: {
                return PlayerQuestController.isQuestCompleted(player, id);
            }
            case CanStart: {
                return PlayerQuestController.canQuestBeAccepted(player, id);
            }
        }
        return false;
    }

    public void load(NBTTagCompound compound) {
        int s;
        int g;
        String key;
        int i;
        int v;
        this.clear();
        this.version = compound.func_74762_e("ModRev");
        VersionCompatibility.CheckAvailabilityCompatibility(this, compound);
        this.minPlayerLevel = compound.func_74762_e("AvailabilityMinPlayerLevel");
        if (compound.func_150297_b("AvailabilityDayTime", 11)) {
            this.daytime = compound.func_74759_k("AvailabilityDayTime");
        } else {
            int v2 = compound.func_74762_e("AvailabilityDayTime");
            if (v2 < 0) {
                v2 *= -1;
            }
            if (v2 >= EnumDayTime.values().length) {
                v2 %= EnumDayTime.values().length;
            }
            switch (EnumDayTime.values()[v2]) {
                case Night: {
                    this.daytime[0] = 18;
                    this.daytime[1] = 6;
                    break;
                }
                case Day: {
                    this.daytime[0] = 6;
                    this.daytime[1] = 18;
                    break;
                }
                default: {
                    this.daytime[0] = 0;
                    this.daytime[1] = 0;
                }
            }
        }
        if (compound.func_150297_b("AvailabilityDialogs", 9)) {
            for (int d = 0; d < this.max && d < compound.func_150295_c("AvailabilityDialogs", 10).func_74745_c(); ++d) {
                NBTTagCompound nbtDialog = compound.func_150295_c("AvailabilityDialogs", 10).func_150305_b(d);
                v = nbtDialog.func_74762_e("Availability");
                if (v < 0) {
                    v *= -1;
                }
                if (v >= EnumAvailabilityDialog.values().length) {
                    v %= EnumAvailabilityDialog.values().length;
                }
                this.dialogues.put(nbtDialog.func_74762_e("ID"), EnumAvailabilityDialog.values()[v]);
            }
        } else if (compound.func_150297_b("AvailabilityDialogId", 3)) {
            for (i = 0; i < 4; ++i) {
                String string = key = i == 0 ? "" : "" + (i + 1);
                if (compound.func_74762_e("AvailabilityDialog" + key + "Id") <= 0) continue;
                v = compound.func_74762_e("AvailabilityDialog" + key);
                if (v < 0) {
                    v *= -1;
                }
                if (v >= EnumAvailabilityDialog.values().length) {
                    v %= EnumAvailabilityDialog.values().length;
                }
                this.dialogues.put(compound.func_74762_e("AvailabilityDialog" + key + "Id"), EnumAvailabilityDialog.values()[v]);
            }
        }
        if (compound.func_150297_b("AvailabilityQuests", 9)) {
            for (int q = 0; q < this.max && q < compound.func_150295_c("AvailabilityQuests", 10).func_74745_c(); ++q) {
                NBTTagCompound nbtQuest = compound.func_150295_c("AvailabilityQuests", 10).func_150305_b(q);
                v = nbtQuest.func_74762_e("Availability");
                if (v < 0) {
                    v *= -1;
                }
                if (v >= EnumAvailabilityQuest.values().length) {
                    v %= EnumAvailabilityQuest.values().length;
                }
                this.quests.put(nbtQuest.func_74762_e("ID"), EnumAvailabilityQuest.values()[v]);
            }
        } else if (compound.func_150297_b("AvailabilityQuestId", 3)) {
            for (i = 0; i < 4; ++i) {
                String string = key = i == 0 ? "" : "" + (i + 1);
                if (compound.func_74762_e("AvailabilityQuest" + key + "Id") <= 0) continue;
                v = compound.func_74762_e("AvailabilityQuest" + key);
                if (v < 0) {
                    v *= -1;
                }
                if (v >= EnumAvailabilityDialog.values().length) {
                    v %= EnumAvailabilityDialog.values().length;
                }
                this.dialogues.put(compound.func_74762_e("AvailabilityQuest" + key + "Id"), EnumAvailabilityDialog.values()[v]);
            }
        }
        if (compound.func_150297_b("AvailabilityFactions", 9)) {
            for (int f = 0; f < this.max && f < compound.func_150295_c("AvailabilityFactions", 10).func_74745_c(); ++f) {
                NBTTagCompound nbtFaction = compound.func_150295_c("AvailabilityFactions", 10).func_150305_b(f);
                v = nbtFaction.func_74762_e("Stance");
                if (v < 0) {
                    v *= -1;
                }
                if (v >= EnumAvailabilityFaction.values().length) {
                    v %= EnumAvailabilityFaction.values().length;
                }
                if ((g = nbtFaction.func_74762_e("Availability")) < 0) {
                    g *= -1;
                }
                if (g >= EnumAvailabilityFactionType.values().length) {
                    v %= EnumAvailabilityFactionType.values().length;
                }
                this.factions.put(nbtFaction.func_74762_e("ID"), new AvailabilityFactionData(EnumAvailabilityFactionType.values()[g], EnumAvailabilityFaction.values()[v]));
            }
        } else if (compound.func_150297_b("AvailabilityFactionId", 3)) {
            for (i = 0; i < 4; ++i) {
                String string = key = i == 0 ? "" : "2";
                if (compound.func_74762_e("AvailabilityFaction" + key + "Id") <= 0) continue;
                v = compound.func_74762_e("AvailabilityFaction" + key + "Stance");
                if (v < 0) {
                    v *= -1;
                }
                if (v >= EnumAvailabilityFaction.values().length) {
                    v %= EnumAvailabilityFaction.values().length;
                }
                if ((g = compound.func_74762_e("AvailabilityFaction" + key)) < 0) {
                    g *= -1;
                }
                if (g >= EnumAvailabilityFactionType.values().length) {
                    g %= EnumAvailabilityFactionType.values().length;
                }
                this.factions.put(compound.func_74762_e("AvailabilityFaction" + key + "Id"), new AvailabilityFactionData(EnumAvailabilityFactionType.values()[g], EnumAvailabilityFaction.values()[v]));
            }
        }
        if (compound.func_150297_b("AvailabilityScoreboards", 9)) {
            for (s = 0; s < this.max && s < compound.func_150295_c("AvailabilityScoreboards", 10).func_74745_c(); ++s) {
                NBTTagCompound nbtScoreboard = compound.func_150295_c("AvailabilityScoreboards", 10).func_150305_b(s);
                v = nbtScoreboard.func_74762_e("Availability");
                if (v < 0) {
                    v *= -1;
                }
                this.scoreboards.put(nbtScoreboard.func_74779_i("Objective"), new AvailabilityScoreboardData(EnumAvailabilityScoreboard.values()[v %= EnumAvailabilityScoreboard.values().length], nbtScoreboard.func_74762_e("Value")));
                this.initScore(nbtScoreboard.func_74779_i("Objective"));
            }
        } else if (compound.func_150297_b("AvailabilityScoreboardObjective", 8)) {
            for (i = 0; i < 2; ++i) {
                String string = key = i == 0 ? "" : "2";
                if (compound.func_74779_i("AvailabilityScoreboard" + key + "Objective").isEmpty()) continue;
                String objective = compound.func_74779_i("AvailabilityScoreboard" + key + "Objective");
                int v3 = compound.func_74762_e("AvailabilityScoreboardType" + key);
                if (v3 < 0) {
                    v3 *= -1;
                }
                this.scoreboards.put(objective, new AvailabilityScoreboardData(EnumAvailabilityScoreboard.values()[v3 %= EnumAvailabilityScoreboard.values().length], compound.func_74762_e("AvailabilityScoreboard" + key + "Value")));
                this.initScore(objective);
            }
        }
        if (compound.func_150297_b("AvailabilityPlayerNames", 9)) {
            for (s = 0; s < compound.func_150295_c("AvailabilityPlayerNames", 10).func_74745_c(); ++s) {
                NBTTagCompound nbtName = compound.func_150295_c("AvailabilityPlayerNames", 10).func_150305_b(s);
                int v4 = compound.func_74762_e("Availability");
                if (v4 < 0) {
                    v4 *= -1;
                }
                if (v4 >= EnumAvailabilityPlayerName.values().length) {
                    v4 %= EnumAvailabilityPlayerName.values().length;
                }
                this.playerNames.put(nbtName.func_74779_i("Name"), EnumAvailabilityPlayerName.values()[v4]);
            }
        }
        if (compound.func_150297_b("AvailabilityStoredData", 9)) {
            for (i = 0; i < compound.func_150295_c("AvailabilityStoredData", 10).func_74745_c(); ++i) {
                AvailabilityStoredData asd = new AvailabilityStoredData(compound.func_150295_c("AvailabilityStoredData", 10).func_150305_b(i));
                boolean found = false;
                for (AvailabilityStoredData sd : this.storeddata) {
                    if (!sd.key.equals(asd.key)) continue;
                    found = true;
                    sd.value = asd.value;
                    sd.type = asd.type;
                    break;
                }
                if (found) continue;
                this.storeddata.add(asd);
            }
        }
        if (compound.func_150297_b("AvailabilityHealth", 3)) {
            this.health = compound.func_74762_e("AvailabilityHealth");
            if (this.health < 0) {
                this.health = 0;
            }
            if (this.health > 100) {
                this.health = 100;
            }
            this.healthType = compound.func_74762_e("AvailabilityHealthType");
            if (this.healthType < 0) {
                this.healthType *= -1;
            }
            if (this.healthType > 2) {
                this.healthType %= 3;
            }
        }
        this.onlyGM = compound.func_74767_n("OnlyGM");
        this.stacks.func_174888_l();
        if (compound.func_150297_b("NpcMiscInv", 9)) {
            this.stacks.load(compound);
        }
        this.stacksData.clear();
        if (compound.func_150297_b("AvailabilityMiscInv", 9)) {
            for (i = 0; i < compound.func_150295_c("AvailabilityMiscInv", 10).func_74745_c() && i < 9; ++i) {
                this.stacksData.put(i, new AvailabilityStackData(compound.func_150295_c("AvailabilityMiscInv", 10).func_150305_b(i)));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (this.stacksData.containsKey(i)) continue;
            this.stacksData.put(i, new AvailabilityStackData());
        }
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void removeDialog(int id) {
        this.dialogues.remove(id);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void removeFaction(int id) {
        this.factions.remove(id);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void removePlayerName(String name) {
        this.playerNames.remove(name);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void removeQuest(int id) {
        this.quests.remove(id);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void removeScoreboard(String objective) {
        this.scoreboards.remove(objective);
        for (String obj : this.scoreboards.keySet()) {
            if (!obj.equals(objective)) continue;
            this.scoreboards.remove(obj);
            return;
        }
    }

    @Override
    public void removeStoredData(String key) {
        for (AvailabilityStoredData sd : this.storeddata) {
            if (!sd.key.equals(key)) continue;
            this.storeddata.remove(sd);
            break;
        }
        this.hasOptions = this.checkHasOptions();
    }

    public boolean scoreboardAvailable(EntityPlayer player, String objective, EnumAvailabilityScoreboard type, int value) {
        if (objective.isEmpty()) {
            return true;
        }
        ScoreObjective sbObjective = player.func_96123_co().func_96518_b(objective);
        if (sbObjective == null) {
            return false;
        }
        if (!player.func_96123_co().func_178819_b(player.func_70005_c_(), sbObjective)) {
            return false;
        }
        int i = player.func_96123_co().func_96529_a(player.func_70005_c_(), sbObjective).func_96652_c();
        if (type == EnumAvailabilityScoreboard.EQUAL) {
            return i == value;
        }
        if (type == EnumAvailabilityScoreboard.BIGGER) {
            return i > value;
        }
        return i < value;
    }

    @Override
    public void setDaytime(int type) {
        switch (EnumDayTime.values()[MathHelper.func_76125_a((int)type, (int)0, (int)2)]) {
            case Night: {
                this.daytime[0] = 18;
                this.daytime[1] = 6;
                break;
            }
            case Day: {
                this.daytime[0] = 6;
                this.daytime[1] = 18;
                break;
            }
            default: {
                this.daytime[0] = 0;
                this.daytime[1] = 0;
            }
        }
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setDaytime(int minHour, int maxHour) {
        this.daytime[0] = minHour;
        this.daytime[1] = maxHour;
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setDialog(int id, int type) {
        if (this.dialogues.size() >= this.max) {
            throw new CustomNPCsException("The maximum number is already set to " + this.max, new Object[0]);
        }
        this.dialogues.put(id, EnumAvailabilityDialog.values()[ValueUtil.correctInt(type, 0, 2)]);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setFaction(int id, int type, int stance) {
        if (this.factions.size() >= this.max) {
            throw new CustomNPCsException("The maximum number is already set to " + this.max, new Object[0]);
        }
        this.factions.put(id, new AvailabilityFactionData(EnumAvailabilityFactionType.values()[ValueUtil.correctInt(type, 0, 2)], EnumAvailabilityFaction.values()[ValueUtil.correctInt(stance, 0, 2)]));
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setHealth(int value, int type) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.health = value;
        if (type < 0) {
            type *= -1;
        }
        if (type > 2) {
            type %= 3;
        }
        this.healthType = type;
    }

    @Override
    public void setMinPlayerLevel(int level) {
        this.minPlayerLevel = level;
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setPlayerName(String name, int type) {
        if (type < 0) {
            type *= -1;
        }
        this.playerNames.put(name, EnumAvailabilityPlayerName.values()[type %= EnumAvailabilityPlayerName.values().length]);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setQuest(int id, int type) {
        if (this.quests.size() >= this.max) {
            throw new CustomNPCsException("The maximum number is already set to " + this.max, new Object[0]);
        }
        this.quests.put(id, EnumAvailabilityQuest.values()[ValueUtil.correctInt(type, 0, 6)]);
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setScoreboard(String objective, int type, int value) {
        if (this.scoreboards.size() >= this.max) {
            throw new CustomNPCsException("The maximum number is already set to " + this.max, new Object[0]);
        }
        if (objective == null || objective.isEmpty()) {
            throw new CustomNPCsException("Objective must not be empty", new Object[0]);
        }
        this.scoreboards.put(objective, new AvailabilityScoreboardData(EnumAvailabilityScoreboard.values()[ValueUtil.correctInt(type, 0, EnumAvailabilityScoreboard.values().length - 1)], value));
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public void setStoredData(String key, String value, int type) {
        boolean found = false;
        if (type < 0) {
            type *= -1;
        }
        EnumAvailabilityStoredData t = EnumAvailabilityStoredData.values()[type % EnumAvailabilityStoredData.values().length];
        for (AvailabilityStoredData sd : this.storeddata) {
            if (!sd.key.equals(key)) continue;
            found = true;
            sd.value = value;
            sd.type = t;
            break;
        }
        if (!found) {
            this.storeddata.add(new AvailabilityStoredData(key, value, t));
        }
        this.hasOptions = this.checkHasOptions();
    }

    @Override
    public boolean getGMOnly() {
        return this.onlyGM;
    }

    @Override
    public void setGMOnly(boolean gmOnly) {
        this.onlyGM = gmOnly;
    }

    @Override
    public IItemStack getIItemStack(int slotID) {
        if (slotID < 0 || slotID > 9) {
            return null;
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(this.stacks.func_70301_a(slotID));
    }

    @Override
    public IItemStack[] getIItemStacks() {
        ArrayList<IItemStack> list = new ArrayList<IItemStack>();
        for (ItemStack stack : this.stacks.items) {
            list.add(Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack));
        }
        return list.toArray(new IItemStack[0]);
    }

    @Override
    public void setIItemStack(int slotID, IItemStack item) {
        if (slotID < 0 || slotID > 9) {
            return;
        }
        this.stacks.func_70299_a(slotID, item.getMCItemStack());
    }

    @Override
    public void removeIItemStack(int slotID) {
        if (slotID < 0 || slotID > 9) {
            return;
        }
        this.stacks.func_70299_a(slotID, ItemStack.field_190927_a);
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        int st = 0;
        for (ItemStack stack : this.stacks.items) {
            if (NoppesUtilServer.IsItemStackNull(stack)) continue;
            ++st;
        }
        return "Availability hasOptions: " + this.hasOptions + ", maxData: " + this.max + ", { scoreboards:" + this.scoreboards.size() + ", dialogues:" + this.dialogues.size() + ", quests:" + this.quests.size() + ", factions:" + this.factions.size() + ", time[min:" + this.daytime[0] + ", max:" + this.daytime[0] + "], playerNames:" + this.playerNames.size() + ", StoredDatas:" + this.storeddata.size() + ", ItemStacks:" + st + ", Regions:" + this.regions.size() + ", playerData[Lv:" + this.minPlayerLevel + ", H:" + this.health + ", HT:" + this.healthType + "] }";
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74768_a("ModRev", this.version);
        compound.func_74783_a("AvailabilityDayTime", this.daytime);
        compound.func_74768_a("AvailabilityMinPlayerLevel", this.minPlayerLevel);
        NBTTagList listD = new NBTTagList();
        for (int id : this.dialogues.keySet()) {
            NBTTagCompound nbtDialog = new NBTTagCompound();
            nbtDialog.func_74768_a("ID", id);
            nbtDialog.func_74768_a("Availability", this.dialogues.get(id).ordinal());
            listD.func_74742_a((NBTBase)nbtDialog);
        }
        compound.func_74782_a("AvailabilityDialogs", (NBTBase)listD);
        NBTTagList listQ = new NBTTagList();
        for (int id : this.quests.keySet()) {
            NBTTagCompound nbtQuest = new NBTTagCompound();
            nbtQuest.func_74768_a("ID", id);
            nbtQuest.func_74768_a("Availability", this.quests.get(id).ordinal());
            listQ.func_74742_a((NBTBase)nbtQuest);
        }
        compound.func_74782_a("AvailabilityQuests", (NBTBase)listQ);
        NBTTagList listF = new NBTTagList();
        for (int id : this.factions.keySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("ID", id);
            nBTTagCompound.func_74768_a("Availability", this.factions.get((Object)Integer.valueOf((int)id)).factionAvailable.ordinal());
            nBTTagCompound.func_74768_a("Stance", this.factions.get((Object)Integer.valueOf((int)id)).factionStance.ordinal());
            listF.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("AvailabilityFactions", (NBTBase)listF);
        NBTTagList listS = new NBTTagList();
        for (String string : this.scoreboards.keySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Objective", string);
            nBTTagCompound.func_74768_a("Availability", this.scoreboards.get((Object)string).scoreboardType.ordinal());
            nBTTagCompound.func_74768_a("Value", this.scoreboards.get((Object)string).scoreboardValue);
            listS.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("AvailabilityScoreboards", (NBTBase)listS);
        NBTTagList listPN = new NBTTagList();
        for (String string : this.playerNames.keySet()) {
            NBTTagCompound nbtName = new NBTTagCompound();
            nbtName.func_74778_a("Name", string);
            nbtName.func_74768_a("Availability", this.playerNames.get(string).ordinal());
            listPN.func_74742_a((NBTBase)nbtName);
        }
        compound.func_74782_a("AvailabilityPlayerNames", (NBTBase)listPN);
        NBTTagList nBTTagList = new NBTTagList();
        for (AvailabilityStoredData sd : this.storeddata) {
            nBTTagList.func_74742_a((NBTBase)sd.writeToNBT());
        }
        compound.func_74782_a("AvailabilityStoredData", (NBTBase)nBTTagList);
        compound.func_74768_a("AvailabilityHealth", this.health);
        compound.func_74768_a("AvailabilityHealthType", this.healthType);
        compound.func_74757_a("OnlyGM", this.onlyGM);
        compound.func_74782_a("NpcMiscInv", (NBTBase)NBTTags.nbtItemStackList(this.stacks.items));
        NBTTagList nBTTagList2 = new NBTTagList();
        for (AvailabilityStackData mi : this.stacksData.values()) {
            nBTTagList2.func_74742_a((NBTBase)mi.writeToNBT());
        }
        compound.func_74782_a("AvailabilityMiscInv", (NBTBase)nBTTagList2);
        return compound;
    }

    public List<String> getAvailability(EntityPlayer player) {
        StringBuilder data;
        ArrayList<String> list = new ArrayList<String>();
        if (!this.hasOptions) {
            return list;
        }
        list.add(new TextComponentTranslation("availability.options", new Object[0]).func_150254_d() + ":");
        boolean gm = player.field_71075_bZ.field_75098_d;
        if (this.daytime[0] >= 0 && this.daytime[0] <= 23 && this.daytime[1] >= 0 && this.daytime[1] <= 23 && this.daytime[0] != this.daytime[1]) {
            int time = (int)((player.field_70170_p.func_72820_D() + 30000L) % 24000L) / 1000;
            boolean bo = this.daytime[0] < this.daytime[1] ? time > this.daytime[0] && time < this.daytime[1] : time > this.daytime[0] || time < this.daytime[1];
            boolean hasClock = false;
            if (player.field_71075_bZ.field_75098_d) {
                hasClock = true;
            } else {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (NoppesUtilServer.IsItemStackNull(stack) || !(stack.func_77973_b() instanceof ItemClock)) continue;
                    hasClock = true;
                    break;
                }
            }
            if (hasClock) {
                list.add(new TextComponentTranslation("availability.type.daytime.1", new Object[]{"\u00a72" + this.daytime[0] + ":00", "\u00a72" + this.daytime[1] + ":00", "\u00a76" + time + ":00", new TextComponentTranslation("quest.task.manual." + (bo ? "0" : "1"), new Object[0]).func_150254_d()}).func_150254_d());
            } else {
                list.add(new TextComponentTranslation("availability.type.daytime.0", new Object[]{new TextComponentTranslation("quest.task.manual." + (bo ? "0" : "1"), new Object[0]).func_150254_d()}).func_150254_d());
            }
        }
        if (!this.dialogues.isEmpty()) {
            DialogController dData = DialogController.instance;
            data = new StringBuilder();
            for (int id : this.dialogues.keySet()) {
                if (this.dialogues.get(id) != EnumAvailabilityDialog.Always) continue;
                if (data.toString().isEmpty()) {
                    data.append("; ");
                }
                Dialog d = dData.get(id);
                data.append(new TextComponentTranslation("availability." + this.dialogues.get(id).name().toLowerCase(), new Object[0]).func_150254_d()).append(" ");
                if (d == null || gm) {
                    data.append('\u00a7').append("7ID: ").append('\u00a7').append("6").append(id).append('\u00a7').append("r").append(gm ? " - " : "");
                }
                if (d != null) {
                    data.append(new TextComponentTranslation(d.getName(), new Object[0]).func_150254_d());
                }
                data.append(new TextComponentTranslation("quest.task.manual." + (this.dialogAvailable(id, this.dialogues.get(id), player) ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.dialogues", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (!this.quests.isEmpty()) {
            QuestController qData = QuestController.instance;
            data = new StringBuilder();
            for (int id : this.quests.keySet()) {
                IQuest q;
                if (this.quests.get(id) != EnumAvailabilityQuest.Always) continue;
                if (data.toString().isEmpty()) {
                    data.append("; ");
                }
                if ((q = qData.get(id)) == null || gm) {
                    data.append('\u00a7').append("7ID: ").append('\u00a7').append("6").append(id).append('\u00a7').append("r").append(gm ? " - " : "");
                }
                data.append(new TextComponentTranslation("availability." + this.quests.get(id).name().toLowerCase(), new Object[0]).func_150254_d()).append(" ");
                if (q != null) {
                    data.append(q.getTitle());
                }
                data.append(new TextComponentTranslation("quest.task.manual." + (this.questAvailable(id, this.quests.get(id), player) ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.quests", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (!this.factions.isEmpty()) {
            FactionController fData = FactionController.instance;
            data = new StringBuilder();
            for (int id : this.factions.keySet()) {
                IFaction f;
                if (this.factions.get((Object)Integer.valueOf((int)id)).factionAvailable == EnumAvailabilityFactionType.Always) continue;
                if (data.toString().isEmpty()) {
                    data.append("; ");
                }
                if ((f = fData.get(id)) == null || gm) {
                    data.append('\u00a7').append("7ID: ").append('\u00a7').append("6").append(id).append('\u00a7').append("r").append(gm ? " - " : "");
                }
                data.append(new TextComponentTranslation("availability." + this.factions.get((Object)Integer.valueOf((int)id)).factionAvailable.name().toLowerCase(), new Object[0]).func_150254_d()).append(" ");
                String attitude = this.factions.get((Object)Integer.valueOf((int)id)).factionStance == EnumAvailabilityFaction.Hostile ? "aggressive" : this.factions.get((Object)Integer.valueOf((int)id)).factionAvailable.name().toLowerCase();
                data.append(new TextComponentTranslation("faction.name." + attitude, new Object[0]).func_150254_d()).append(" ");
                if (f != null) {
                    data.append(f.getName());
                }
                data.append(new TextComponentTranslation("quest.task.manual." + (this.factionAvailable(id, this.factions.get((Object)Integer.valueOf((int)id)).factionStance, this.factions.get((Object)Integer.valueOf((int)id)).factionAvailable, player) ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.factions", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (!this.scoreboards.isEmpty()) {
            data = new StringBuilder();
            for (String obj : this.scoreboards.keySet()) {
                if (data.toString().isEmpty()) {
                    data.append("; ");
                }
                data.append(new TextComponentTranslation("gui.name", new Object[0]).func_150254_d()).append(": ").append(obj);
                data.append(new TextComponentTranslation("availability." + this.scoreboards.get((Object)obj).scoreboardType.name().toLowerCase(), new Object[0]).func_150254_d()).append(" ").append(this.scoreboards.get((Object)obj).scoreboardValue);
                data.append(new TextComponentTranslation("quest.task.manual." + (this.scoreboardAvailable(player, obj, this.scoreboards.get((Object)obj).scoreboardType, this.scoreboards.get((Object)obj).scoreboardValue) ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.scoreboards", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (!this.playerNames.isEmpty()) {
            data = new StringBuilder();
            ArrayList<String> listOnly = new ArrayList<String>();
            ArrayList<String> listExcept = new ArrayList<String>();
            for (String name : this.playerNames.keySet()) {
                switch (this.playerNames.get(name)) {
                    case Only: {
                        listOnly.add(name);
                        break;
                    }
                    case Except: {
                        listExcept.add(name);
                    }
                }
            }
            if (!listOnly.isEmpty()) {
                data.append(new TextComponentTranslation("availability.only", new Object[0]).func_150254_d()).append("[");
                boolean st = true;
                for (String name : listOnly) {
                    if (!st) {
                        data.append("; ");
                    } else {
                        st = false;
                    }
                    data.append(name);
                }
                data.append("]").append(new TextComponentTranslation("quest.task.manual." + (listOnly.contains(player.func_70005_c_()) ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!listExcept.isEmpty()) {
                data.append(new TextComponentTranslation("availability.except", new Object[0]).func_150254_d()).append("[");
                boolean st = true;
                for (String name : listExcept) {
                    if (!st) {
                        data.append("; ");
                    } else {
                        st = false;
                    }
                    data.append(name);
                }
                data.append("]").append(new TextComponentTranslation("quest.task.manual." + (listExcept.contains(player.func_70005_c_()) ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.player.names", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (!this.storeddata.isEmpty()) {
            data = new StringBuilder();
            IData dataP = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player).getStoreddata();
            for (AvailabilityStoredData sd : this.storeddata) {
                EnumAvailabilityStoredData type = sd.type;
                Object value = dataP.get(sd.key);
                boolean isNumber = false;
                boolean bo = true;
                if (type != EnumAvailabilityStoredData.ONLY && type != EnumAvailabilityStoredData.EXCEPT) {
                    if (!(value instanceof Number) && !(value instanceof String)) {
                        bo = false;
                    }
                    try {
                        double dsV;
                        double aV = Double.parseDouble(sd.value);
                        double d = dsV = value instanceof Number ? (Double)value : Double.parseDouble((String)value);
                        if (type == EnumAvailabilityStoredData.EQUAL && dsV != aV) {
                            bo = false;
                        }
                        if (type == EnumAvailabilityStoredData.BIGGER && dsV < aV) {
                            bo = false;
                        }
                        if (type == EnumAvailabilityStoredData.SMALLER && dsV > aV) {
                            bo = false;
                        }
                        isNumber = true;
                    }
                    catch (Exception e) {
                        bo = false;
                    }
                }
                if (!isNumber && (dataP.has(sd.key) && type == EnumAvailabilityStoredData.EXCEPT || !dataP.has(sd.key) && type == EnumAvailabilityStoredData.ONLY)) {
                    bo = false;
                }
                if (data.toString().isEmpty()) {
                    data.append("; ");
                }
                data.append(new TextComponentTranslation("gui.name", new Object[0]).func_150254_d()).append(": ").append(sd.key);
                data.append(new TextComponentTranslation("quest.task.item." + (bo ? "0" : "1"), new Object[0]).func_150254_d());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.storeddata", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (!this.stacks.func_191420_l()) {
            data = new StringBuilder();
            boolean st = true;
            for (ItemStack stack : this.stacks.items) {
                if (stack.func_190926_b()) continue;
                if (!st) {
                    data.append("; ");
                } else {
                    st = false;
                }
                data.append(stack.func_82833_r());
                if (stack.func_190916_E() <= 0) continue;
                data.append(" x").append(stack.func_190916_E());
            }
            if (!data.toString().isEmpty()) {
                list.add(new TextComponentTranslation("availability.type.stacks", new Object[]{data.toString()}).func_150254_d());
            }
        }
        if (this.healthType != 0) {
            data = new StringBuilder();
            int h = (int)(player.func_110143_aJ() / player.func_110138_aP() * 100.0f);
            data.append(new TextComponentTranslation("availability." + (this.healthType == 1 ? "smaller" : "bigger"), new Object[0])).append(" ").append(h).append("%");
            data.append(new TextComponentTranslation("quest.task.item." + (this.healthType == 1 && h < this.health || this.healthType == 2 && h > this.health ? "1" : "0"), new Object[0]).func_150254_d());
            list.add(new TextComponentTranslation("availability.type.health", new Object[]{data.toString()}).func_150254_d());
        }
        if (this.onlyGM) {
            data = new StringBuilder();
            data.append(new TextComponentTranslation("gui.enabled", new Object[0]).func_150254_d());
            data.append(new TextComponentTranslation("quest.task.manual." + (gm ? "0" : "1"), new Object[0]).func_150254_d());
            list.add(new TextComponentTranslation("availability.type.only.gm", new Object[]{data.toString()}).func_150254_d());
        }
        if (this.minPlayerLevel > 0) {
            data = new StringBuilder();
            data.append(new TextComponentTranslation("availability.bigger", new Object[0]).func_150254_d()).append(" ").append(this.minPlayerLevel);
            data.append(new TextComponentTranslation("quest.task.manual." + (player.field_71068_ca >= this.minPlayerLevel ? "0" : "1"), new Object[0]).func_150254_d());
            list.add(new TextComponentTranslation("availability.type.level", new Object[]{data.toString()}).func_150254_d());
        }
        return list;
    }
}

